package cn.com.duiba.live.conf.service.api.enums.livestream;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 阿里云实时录制指令枚举
 *
 * @author xuzhigang
 * @date 2021/4/27 2:40 下午
 **/
@Getter
@AllArgsConstructor
public enum RealTimeRecordCommandEnum {

    START("start", "强制启动录制"),

    STOP("stop", "强制暂停录制"),

    CANCEL_DELAY("cancel_delay", "重置断流延迟时间，完全停止录制"),

    RESTART("restart", "强制重新开始录制"),
    ;

    /**
     * 命令
     */
    private final String command;

    /**
     * 描述
     */
    private final String desc;
}
