/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.conf.service.api.enums.conf;

import cn.com.duiba.live.conf.service.api.util.NumberUtil;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum LiveInteractTypeEnum {
    MATERIAL(1, "\u56fe\u6587\u8d44\u6599"),
    QUESTION(2, "\u95ee\u9898"),
    SUBSCRIBE(3, "\u5173\u6ce8\u76f4\u64ad\u95f4"),
    ACCUMULATE_READ(4, "\u7d2f\u8ba1\u89c2\u770b"),
    FRIEND_INVITE(5, "\u9080\u8bf7\u597d\u53cb"),
    FREE_GET(6, "\u514d\u8d39\u9886"),
    GRAB_WELFARE(7, "\u62a2\u6743\u76ca"),
    CHOICE(8, "\u6d4b\u4e00\u6d4b"),
    LINK_RESOURCE(9, "\u94fe\u63a5\u8d44\u6599"),
    OA_RESOURCE(10, "\u516c\u4f17\u53f7\u8d44\u6599"),
    FREE_RESOURCE(11, "\u514d\u8d39\u9886\u8d44\u6599"),
    FORM_RESOURCE(12, "\u8868\u5355\u8d44\u6599"),
    TEST_RESOURCE(13, "\u6d4b\u8bd5\u8d44\u6599"),
    GAME_RESOURCE(14, "\u5c0f\u6e38\u620f\u8d44\u6599"),
    QUES_REWARD(15, "\u7b54\u9898\u9886\u5956"),
    FISSION_TREASURE_AWARD(16, "\u88c2\u53d8\u5b9d\u7bb1\u5956\u54c1"),
    TIME_TREASURE_AWARD(17, "\u505c\u7559\u65f6\u957f\u5b9d\u7bb1\u5956\u54c1"),
    TIMED_CHOICE(18, "\u63a8\u9001\u5b9a\u65f6\u6295\u7968"),
    TREASURE_TEAM_AWARD(19, "\u5b9d\u7bb1-\u56e2\u961f\u5956\u52b1"),
    BUY_INSURANCE_AWARD(20, "\u76f4\u64ad\u4e2d\u8d2d\u4e70\u4fdd\u9669-\u5956\u52b1"),
    LIVE_SURVEY_AWARD(21, "\u76f4\u64ad\u4e2d\u63d0\u4ea4\u95ee\u5377-\u5956\u52b1"),
    LIVE_SECOND_KILL_GOODS(22, "\u79d2\u6740\u5546\u54c1"),
    EVALUATION_RESOURCE(23, "\u6d4b\u8bc4\u8d44\u6599"),
    GOLDEN_EGG_TREASURE_AWARD(24, "\u7838\u91d1\u86cb\u5b9d\u7bb1\u5956\u54c1"),
    LIVE_SURVEY_REWARD(25, "\u76f4\u64ad\u95ee\u5238\u6709\u5956"),
    MALL_SALE_GOODS(26, "\u76f4\u64ad\u5546\u57ce\u552e\u5356\u5546\u54c1"),
    MALL_LIVING_LOTTERY(27, "\u76f4\u64ad\u4e2d\u62bd\u5956-\u5546\u57ce\u7248"),
    MALL_FISSION_TREASURE_AWARD(28, "\u88c2\u53d8\u5b9d\u7bb1-\u5546\u57ce\u7248"),
    MALL_TIME_TREASURE_AWARD(29, "\u65f6\u957f\u5b9d\u7bb1-\u5546\u57ce\u7248"),
    MALL_FREE_GET(30, "\u514d\u8d39\u9886-\u5546\u57ce\u7248"),
    MALL_GOLDEN_EGG_TREASURE_AWARD(31, "\u7838\u91d1\u86cb-\u5546\u57ce\u7248"),
    MALL_QUES_REWARD(32, "\u6709\u5956\u7b54\u9898-\u5546\u57ce\u7248"),
    MALL_LIVE_SURVEY_AWARD(33, "\u95ee\u5377\u6709\u5956-\u5546\u57ce\u7248");

    private Integer type;
    private String desc;
    public static List<Integer> welfareTypes;
    @Deprecated
    public static final List<Integer> resourceTypes;
    public static List<Integer> welfareTableTypes;
    public static final List<Integer> MALL_TYPE_LIST;
    public static final List<Integer> LOTTERY_INTERACT_TYPE_LIST;
    private static List<Integer> highQualityWelfareTypes;
    private static List<Integer> highQualityResourceTypes;
    private static final List<Integer> normalResourceTypes;
    private static List<Integer> highQualityTypes;
    private static List<Integer> clueInteractTypes;
    private static List<Integer> mallGoodsTypes;
    public static final List<Integer> TREASURE_AWARD_LIST;
    public static final List<Integer> MALL_TREASURE_AWARD_LIST;

    private LiveInteractTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static boolean isWelfare(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return false;
        }
        return welfareTypes.contains(type);
    }

    @Deprecated
    public static boolean isResource(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return false;
        }
        return resourceTypes.contains(type);
    }

    public static boolean isWelfareTable(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return false;
        }
        return welfareTableTypes.contains(type);
    }

    public static List<Integer> getHighQualityWelfareTypes() {
        return highQualityWelfareTypes;
    }

    public static boolean isHighQualityWelfareType(Integer type) {
        return highQualityWelfareTypes.contains(type);
    }

    public static List<Integer> getHighQualityResourceTypes() {
        return highQualityResourceTypes;
    }

    public static boolean isHighQualityResourceType(Integer type) {
        return highQualityResourceTypes.contains(type);
    }

    public static boolean isNormalResource(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return false;
        }
        return normalResourceTypes.contains(type);
    }

    public static List<Integer> getHighQualityTypes() {
        return highQualityTypes;
    }

    public static List<Integer> getClueInteractTypes() {
        return clueInteractTypes;
    }

    public static List<Integer> getMallGoodsTypes() {
        return mallGoodsTypes;
    }

    static {
        welfareTypes = Lists.newArrayList();
        welfareTypes.addAll(Lists.newArrayList((Object[])new Integer[]{SUBSCRIBE.getType(), ACCUMULATE_READ.getType(), FRIEND_INVITE.getType(), FREE_GET.getType(), GRAB_WELFARE.getType(), MATERIAL.getType(), LINK_RESOURCE.getType()}));
        resourceTypes = Lists.newArrayList();
        resourceTypes.addAll(Lists.newArrayList((Object[])new Integer[]{MATERIAL.getType(), LINK_RESOURCE.getType(), OA_RESOURCE.getType(), FREE_RESOURCE.getType(), FORM_RESOURCE.getType(), TEST_RESOURCE.getType(), GAME_RESOURCE.getType(), EVALUATION_RESOURCE.getType()}));
        welfareTableTypes = Lists.newArrayList();
        welfareTableTypes.addAll(Lists.newArrayList((Object[])new Integer[]{SUBSCRIBE.getType(), ACCUMULATE_READ.getType(), FRIEND_INVITE.getType(), FREE_GET.getType(), GRAB_WELFARE.getType(), FISSION_TREASURE_AWARD.getType(), TIME_TREASURE_AWARD.getType(), TREASURE_TEAM_AWARD.getType(), QUES_REWARD.getType(), BUY_INSURANCE_AWARD.getType(), LIVE_SURVEY_AWARD.getType(), GOLDEN_EGG_TREASURE_AWARD.getType(), LIVE_SURVEY_REWARD.getType(), MALL_LIVING_LOTTERY.getType(), MALL_FISSION_TREASURE_AWARD.getType(), MALL_GOLDEN_EGG_TREASURE_AWARD.getType(), MALL_FREE_GET.getType(), MALL_TIME_TREASURE_AWARD.getType(), MALL_QUES_REWARD.getType(), MALL_LIVE_SURVEY_AWARD.getType()}));
        MALL_TYPE_LIST = Arrays.asList(MALL_LIVING_LOTTERY.getType(), MALL_FISSION_TREASURE_AWARD.getType(), MALL_TIME_TREASURE_AWARD.getType(), MALL_QUES_REWARD.getType(), MALL_LIVE_SURVEY_AWARD.getType(), MALL_GOLDEN_EGG_TREASURE_AWARD.getType(), MALL_FREE_GET.getType());
        LOTTERY_INTERACT_TYPE_LIST = Arrays.asList(GRAB_WELFARE.getType(), MALL_LIVING_LOTTERY.getType());
        highQualityWelfareTypes = Lists.newArrayList();
        highQualityWelfareTypes.addAll(Lists.newArrayList((Object[])new Integer[]{GRAB_WELFARE.getType(), FREE_GET.getType(), MALL_LIVING_LOTTERY.getType(), MALL_FREE_GET.getType()}));
        highQualityResourceTypes = Lists.newArrayList();
        highQualityResourceTypes.addAll(Lists.newArrayList((Object[])new Integer[]{FREE_RESOURCE.getType(), FORM_RESOURCE.getType()}));
        normalResourceTypes = Lists.newArrayList();
        normalResourceTypes.addAll(Lists.newArrayList((Object[])new Integer[]{MATERIAL.getType(), LINK_RESOURCE.getType(), OA_RESOURCE.getType()}));
        highQualityTypes = Lists.newArrayList();
        highQualityTypes.addAll(Lists.newArrayList((Object[])new Integer[]{GRAB_WELFARE.getType(), FREE_GET.getType(), MALL_FREE_GET.getType(), MALL_LIVING_LOTTERY.getType(), FREE_RESOURCE.getType(), FORM_RESOURCE.getType()}));
        clueInteractTypes = Lists.newArrayList();
        clueInteractTypes.addAll(Lists.newArrayList((Object[])new Integer[]{GRAB_WELFARE.getType(), FREE_GET.getType(), MALL_LIVING_LOTTERY.getType(), MALL_FREE_GET.getType(), MATERIAL.getType(), LINK_RESOURCE.getType(), OA_RESOURCE.getType(), FREE_RESOURCE.getType(), FORM_RESOURCE.getType()}));
        mallGoodsTypes = Collections.unmodifiableList(Lists.newArrayList((Object[])new Integer[]{MATERIAL.getType(), LINK_RESOURCE.getType(), OA_RESOURCE.getType(), FREE_RESOURCE.getType(), FORM_RESOURCE.getType(), TEST_RESOURCE.getType(), GAME_RESOURCE.getType(), EVALUATION_RESOURCE.getType(), MALL_SALE_GOODS.getType()}));
        TREASURE_AWARD_LIST = Collections.unmodifiableList(Arrays.asList(FISSION_TREASURE_AWARD.getType(), TIME_TREASURE_AWARD.getType(), GOLDEN_EGG_TREASURE_AWARD.getType()));
        MALL_TREASURE_AWARD_LIST = Collections.unmodifiableList(Arrays.asList(MALL_FISSION_TREASURE_AWARD.getType(), MALL_TIME_TREASURE_AWARD.getType(), MALL_GOLDEN_EGG_TREASURE_AWARD.getType()));
    }
}

