/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.conf.service.api.enums.company;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CompanyBusinessTypeEnum {
    INSURANCE(1, "\u4fdd\u9669"),
    BANK(2, "\u94f6\u884c");

    private final Integer code;
    private final String description;
    private static final Map<Integer, CompanyBusinessTypeEnum> ENUM_MAP;

    public static CompanyBusinessTypeEnum getByType(Integer type) {
        return ENUM_MAP.get(type);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    private CompanyBusinessTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(CompanyBusinessTypeEnum.values()).collect(Collectors.toMap(CompanyBusinessTypeEnum::getCode, Function.identity(), (v1, v2) -> v2)));
    }
}

