/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.conf.service.api.enums.pub.form;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum PubFormAgentEnum {
    OTHER(0, "", ""),
    XM(1, "\u4fe1\u6dfc", "xm"),
    KT(2, "\u5feb\u63a8", "kt"),
    TD(3, "\u5929\u5730", "td"),
    YHGJ(4, "\u94f6\u884c\u4e2a\u91d1", "yhgj"),
    WEIMO(5, "\u5fae\u76df", "weimo"),
    NATURAL(6, "\u81ea\u7136\u91cf", "natural"),
    DIRECT(7, "\u539a\u8d62\u76f4\u6295", "direct"),
    HUOWANG(8, "\u706b\u65fa", "huowang");

    private final Integer code;
    private final String desc;
    private final String shortCode;
    public static final Map<Integer, PubFormAgentEnum> AGENT_MAP;

    public static PubFormAgentEnum getByCode(Integer code) {
        if (Objects.isNull(code)) {
            return OTHER;
        }
        return AGENT_MAP.get(code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getShortCode() {
        return this.shortCode;
    }

    private PubFormAgentEnum(Integer code, String desc, String shortCode) {
        this.code = code;
        this.desc = desc;
        this.shortCode = shortCode;
    }

    static {
        Map map = Arrays.stream(PubFormAgentEnum.values()).collect(Collectors.toMap(PubFormAgentEnum::getCode, Function.identity()));
        AGENT_MAP = Collections.unmodifiableMap(map);
    }
}

