/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.conf.service.api.enums.fortune;

import cn.com.duiba.live.conf.service.api.util.NumberUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum FortuneRedTypeEnum {
    FIXED(1, "\u56fa\u5b9a\u7c7b\u578b"),
    RANDOM(2, "\u968f\u673a\u7c7b\u578b");

    private final Integer type;
    private final String desc;
    private static final Map<Integer, FortuneRedTypeEnum> ENUM_MAP;
    private static final Set<Integer> TYPES;

    public static FortuneRedTypeEnum getEnumItem(Integer sendType) {
        if (NumberUtil.isNullOrLteZero(sendType)) {
            return null;
        }
        return ENUM_MAP.get(sendType);
    }

    public static boolean contains(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return false;
        }
        return TYPES.contains(type);
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private FortuneRedTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(FortuneRedTypeEnum.values()).collect(Collectors.toMap(FortuneRedTypeEnum::getType, Function.identity())));
        TYPES = Collections.unmodifiableSet(Arrays.stream(FortuneRedTypeEnum.values()).map(FortuneRedTypeEnum::getType).collect(Collectors.toSet()));
    }
}

