/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.conf.service.api.enums.mall.coupon;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum MallCouponStatusEnum {
    WAIT_DISTRIBUTE(1, "\u672a\u53d1\u653e"),
    DISTRIBUTING(2, "\u53d1\u653e\u4e2d"),
    MANUAL_INVALID(3, "\u624b\u52a8\u5931\u6548"),
    LIVE_END_INVALID(4, "\u76f4\u64ad\u7ed3\u675f\u81ea\u52a8\u5931\u6548");

    private final Integer status;
    private final String desc;
    public static final List<Integer> END_STATUS_LIST;
    private static final Map<Integer, MallCouponStatusEnum> ENUM_MAP;
    private static final List<Integer> CAN_USE_STATUS;

    public static MallCouponStatusEnum getByStatus(Integer type) {
        return ENUM_MAP.get(type);
    }

    public boolean canUse() {
        return CAN_USE_STATUS.contains(this.status);
    }

    public static boolean canUse(Integer status) {
        if (Objects.isNull(status)) {
            return false;
        }
        return CAN_USE_STATUS.contains(status);
    }

    public static boolean canReceive(Integer status) {
        return Objects.equals(status, DISTRIBUTING.getStatus());
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    private MallCouponStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    static {
        END_STATUS_LIST = Collections.unmodifiableList(Arrays.asList(MANUAL_INVALID.getStatus(), LIVE_END_INVALID.getStatus()));
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(MallCouponStatusEnum.values()).collect(Collectors.toMap(MallCouponStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));
        CAN_USE_STATUS = Arrays.asList(1, 2);
    }
}

