package cn.com.duiba.live.conf.service.api.dto.mall.coupon;

import cn.com.duiba.live.conf.service.api.bean.mall.coupon.MallCouponLimitConfBean;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商城-优惠券
 *
 * @author kjj mybatis generator
 * @date 2022-09-15
 */
@Data
public class MallCouponDto implements Serializable {

    private static final long serialVersionUID = 1663209875275475L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 优惠券名称
     */
    private String couponName;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 业务id 1-直播id
     */
    private Long bizId;

    /**
     * 业务类型 1-直播
     * {@link cn.com.duiba.live.conf.service.api.enums.mall.coupon.MallCouponBizType}
     */
    private Integer bizType;

    /**
     * 优惠券类型 1-满减券
     * {@link cn.com.duiba.live.conf.service.api.enums.mall.coupon.MallCouponType}
     */
    private Integer couponType;

    /**
     * 状态 1-未发放 2-发放中 3-已失效
     * {@link cn.com.duiba.live.conf.service.api.enums.mall.coupon.MallCouponStatusEnum}
     */
    private Integer couponStatus;

    /**
     * 优惠金额
     */
    private Integer discountAmount;

    /**
     * 使用门槛
     */
    private Integer useThreshold;

    /**
     * 发放数量
     */
    private Integer distributeNum;

    /**
     * 限制规则
     */
    private MallCouponLimitConfBean limitConf;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

}