package cn.com.duiba.live.conf.service.api.dto.pre;

import lombok.Data;

import java.io.Serializable;

/**
 * 预告页用户身份-砸金蛋弹窗配置
 * @author kjj mybatis generator 
 * @date 2022-12-08
 */
@Data
public class LivePreGoldenEggConfDto implements Serializable {
     
    private static final long serialVersionUID = 16704635489262039L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 图片链接
     */
    private String picUrl;

    /**
     * 跳转链接
     */
    private String jumpLink;

    /**
     * 跳转链接类型 1-h5 2-小程序
     * {@link cn.com.duiba.live.conf.service.api.enums.pre.JumpLinkTypeEnum}
     */
    private Integer jumpLinkType;

    /**
     * 小程序链接需要appId
     */
    private String appId;

    /**
     * 按钮文案
     */
    private String buttonContent;

    /**
     * 用户持卡身份 1-持卡用户 2-非持卡用户 3-无用户身份
     */
    private Integer userCardRole;
}