package cn.com.duiba.live.conf.service.api.enums.conf.live;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 直播所属部门
 * @author lizhi
 * @date 2023/2/21 1:38 下午
 */
@AllArgsConstructor
@Getter
public enum LiveDepartmentEnum {
    PC(1, "保险业务"),
    BANK(2, "银行直播"),
    CREDIT(3, "信用卡业务"),
    WX_WORK(4, "企微业务"),
    ;

    /**
     * 部门
     */
    private final Integer department;

    /**
     * 部门名称
     */
    private final String name;
    
    private static final Map<Integer, LiveDepartmentEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(LiveDepartmentEnum::getDepartment, Function.identity(), (v1, v2) -> v2)));

    public static LiveDepartmentEnum getByDepartment(Integer department) {
        if (department == null) {
            return null;
        }
        return ENUM_MAP.get(department);
    }
}
