package cn.com.duiba.live.conf.service.api.param.mall.salegoods;

import lombok.Data;

import java.io.Serializable;

/**
 * 直播商品sku入参
 *
 * @author zouwx
 * @date 2022/08/16
 */
@Data
public class SaleGoodsSkuParam implements Serializable {

    private static final long serialVersionUID = 1409133695794420203L;

    /**
     * sku id
     */
    private Long id;

    /**
     * 可售库存
     */
    private Long stock;

    /**
     * 商品规格编码
     */
    private String skuCode;

    /**
     * 规格图片
     */
    private String skuImg;

    /**
     * sku规格属性
     */
    private String attributes;

    /**
     * 市场指导价
     * 单位：分
     */
    private Integer marketPrice;

    /**
     * 直播售价
     * 单位：分
     */
    private Integer discountedPrice;

    /**
     * 使用状态
     * 0=否，1=是
     * {@link cn.com.duiba.kjy.api.enums.BooleanEnum}
     */
    private Integer enableStatus;
}
