package cn.com.duiba.live.conf.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.conf.LiveInteractConfDto;
import cn.com.duiba.live.conf.service.api.dto.conf.ResourceInteractParamDto;
import cn.com.duiba.live.conf.service.api.enums.conf.LiveInteractTypeEnum;
import cn.com.duiba.live.conf.service.api.param.conf.LiveConfPageQueryParam;
import cn.com.duiba.live.conf.service.api.param.conf.LiveFreeConfParam;
import cn.com.duiba.live.conf.service.api.param.conf.LiveInteractConfQueryParam;

import java.util.List;
import java.util.Set;

/**
 * 直播互动配置服务rpc类
 * @author 吴文哲
 * @date 2020-04-02 15:27
 **/
@AdvancedFeignClient
public interface RemoteLiveInteractConfApiService {

    /**
     * 根据条件查询
     * @param param
     * @return
     */
    List<LiveInteractConfDto> findByCondition(LiveInteractConfQueryParam param);

    /**
     * 根据条件查询总数
     * @param param
     * @return
     */
    int countByCondition(LiveInteractConfQueryParam param);

    /**
     * 根据主键查询（缓存）
     * @param id
     * @return
     */
    LiveInteractConfDto selectById(Long id);

    /**
     * 根据主键查询（db)
     * @param id 配置id
     * @return 配置详情
     */
    LiveInteractConfDto findById(Long id);

    /**
     * 获取最近一个未开奖的直播前抽奖配置
     * @param liveId 直播id
     * @return 最近一个未开奖的直播前抽奖配置
     */
    LiveInteractConfDto findLastPreLottery(Long liveId);

    /**
     * 根据主键id查询
     * @param ids 主键id
     * @return 福利配置信息
     */
    List<LiveInteractConfDto> findByIds(Set<Long> ids);

    /**
     * 查询直播所有表单资料ID
     * @param liveId 直播ID
     * @return 资料ID集合
     */
    List<Long> findAllFormResourceId(Long liveId);

    /**
     * 根据条件查询配置条数，管理后端专用
     * @param liveId 直播id
     * @param interactType 配置类型
     * @see cn.com.duiba.live.conf.service.api.enums.conf.LiveInteractTypeEnum
     * @param interactStatus 配置状态
     * @see cn.com.duiba.live.conf.service.api.enums.conf.InteractStatusEnums
     * @return 查询条数
     */
    int findCount(Long liveId, Integer interactType, Integer interactStatus);

    /**
     * 根据直播id+配置类型查询已上架的配置(管理后台专用)
     *
     * @param liveId  直播id
     * @param interactType 配置类型
     * @return 配置列表
     */
    List<LiveInteractConfDto> listByLiveIdAndType(Long liveId, Integer interactType);

    /**
     * 根据互动id和互动类型集合批量查询
     *
     * @param interactId 互动id
     * @param types      互动类型集合
     * @return 互动配置集合
     */
    List<LiveInteractConfDto> findByInteractIdAndTypes(Long interactId, List<Integer> types);

    /** ---------------新增/修改 ----------------***/

    /**
     * 单条插入 返回主键
     * @param dto
     * @return
     */
    Long insert(LiveInteractConfDto dto);

    /**
     * 批量插入 返回主键
     * @param liveList
     * @return
     */
    List<Long> batchInsert(List<LiveInteractConfDto> liveList);


    /**
     * 保存资料配置
     * @param liveId 直播ID
     * @param intreactIdList 互动ID集合
     * @return 执行结果
     */
    @Deprecated
    int saveResourceConf(Long liveId, List<Long> intreactIdList);

    /**
     * 保存资料配置
     * @param liveId 直播ID
     * @param resourceParamList 资料配置集合
     * @return 返回互动对应的配置id
     */
    int saveResourceConf4Resource(Long liveId, List<ResourceInteractParamDto> resourceParamList);

    /**
     * 投票关联资料专用-保存资料配置
     * @param liveId 直播ID
     * @param choiceQuestionIds 投票问题集合
     * @return 执行结果
     */
    int saveResourceConf4Choice(Long liveId, List<Long> choiceQuestionIds);

    /**
     * 批量插入
     * @param dtoList 需要修改的列表
     * @param liveId 直播间id
     * @param interactType 互动类型
     * @return
     */
    Integer batchUpdate(List<LiveInteractConfDto> dtoList,Long liveId,Integer interactType);

    /**
     * 更新
     * @param dto 福利配置信息
     * @return 执行结果
     */
    int update(LiveInteractConfDto dto);

    /**
     * 更新状态
     * @param id 主键
     * @param status 更新状态
     * @param expectedStatus 预期状态
     * @see cn.com.duiba.live.conf.service.api.enums.conf.InteractStatusEnums
     * @return 更新结果
     */
    boolean updateInteractStatus(Long id, Integer status, Integer expectedStatus);

    /**
     * 保存或更新免费领
     * @param param 参数
     * @return 主键id
     */
    Long saveOrUpdateFree(LiveFreeConfParam param);

    /**
     * 根据主键软删除
     * @param id 主键
     * @return 执行结果
     */
    boolean deleteById(Long id);

    /**
     * 批量减少剩余数量
     * @param id 主键
     * @param num 减少的数量
     * @return 执行结果
     */
    int batchReduceSurplusNum(Long id, int num);

    /**
     * 根据直播间id + 互动配置类型查询互动配置id列表
     * @param liveId 直播间id
     * @param interactType 互动配置类型
     * @return 互动配置id列表
     */
    List<Long> findIdsByLiveAndType(Long liveId, Integer interactType);

    /**
     * 分页查询
     *
     * @param liveConfPageQueryParam 直播配置页面查询参数
     * @return {@link List}<{@link LiveInteractConfDto}>
     */
    List<LiveInteractConfDto> findPage(LiveConfPageQueryParam liveConfPageQueryParam);

    /**
     * 分页查询总数
     *
     * @param liveConfPageQueryParam 直播配置页面查询参数
     * @return {@link List}<{@link LiveInteractConfDto}>
     */
     Long findPageCount(LiveConfPageQueryParam liveConfPageQueryParam);

    /**
     * 根据直播id和互动id和类型查询
     *
     * @param liveId     直播id
     * @param interactId 直播互动id
     * @param type       互动类型
     * @see LiveInteractTypeEnum
     * @return {@link LiveInteractConfDto}
     */
    LiveInteractConfDto findByLiveIdAndInteractIdAndType(Long liveId, Long interactId, Integer type);
}
