package cn.com.duiba.live.conf.service.api.remoteservice.welfare;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.conf.service.api.dto.welfare.WelfareDto;
import cn.com.duiba.live.conf.service.api.param.welfare.WelfareQueryParam;

import java.util.List;
import java.util.Map;

/**
 * 权益rpc接口
 * @author 吴文哲
 * @date 2020-04-01 10:45
 **/
@AdvancedFeignClient
public interface RemoteWelfareApiService {

    /**
     * 新增/修改 权益
     * @param dto
     * @return
     */
    Long saveWelfare(WelfareDto dto);

    /**
     * 根据主键删除  逻辑删除
     * @param id
     * @return
     */
    Integer deleteById(Long id);


    /**
     * 根据主键查找
     * @param id
     * @return
     */
    WelfareDto fingById(Long id);

    /**
     * 根据公司id查找 按照
     * @param queryParam
     * @return
     */
    List<WelfareDto> findByCondition(WelfareQueryParam queryParam);

    /**
     * 根据主键ID集合批量查询
     * @param ids
     * @return
     */
    List<WelfareDto> findByIds(List<Long> ids);

    /**
     * 根据id获取福利名称
     * @param ids 主键id
     * @return key：id value：名称
     */
    Map<Long, String> findNameByIds(List<Long> ids);

    /**
     * 根据公司ID查询所有未删除福利数
     * @param companyId 公司ID
     * @return 数量
     */
    Integer countByCompanyId(Long companyId);

}
