/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.conf.service.api.enums.conf.live;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum LiveContractSubjectEnum {
    DUI_BA(1, "\u676d\u5dde\u5151\u5427\u7f51\u7edc\u79d1\u6280\u6709\u9650\u516c\u53f8"),
    DUI_A(2, "\u676d\u5dde\u5151\u554a\u7f51\u7edc\u79d1\u6280\u6709\u9650\u516c\u53f8"),
    KJJ(3, "\u676d\u5dde\u5ba2\u5409\u5409\u7f51\u7edc\u79d1\u6280\u6709\u9650\u516c\u53f8");

    private static final Logger log;
    private final Integer subject;
    private final String name;
    private static final Map<Integer, LiveContractSubjectEnum> ENUM_MAP;

    public static LiveContractSubjectEnum getBySubject(Integer subject) {
        if (subject == null) {
            return null;
        }
        return ENUM_MAP.get(subject);
    }

    private LiveContractSubjectEnum(Integer subject, String name) {
        this.subject = subject;
        this.name = name;
    }

    public Integer getSubject() {
        return this.subject;
    }

    public String getName() {
        return this.name;
    }

    static {
        log = LoggerFactory.getLogger(LiveContractSubjectEnum.class);
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(LiveContractSubjectEnum.values()).collect(Collectors.toMap(LiveContractSubjectEnum::getSubject, Function.identity(), (v1, v2) -> {
            log.error("LiveContractSubjectEnum, distinct, subject={}", (Object)v2.getSubject());
            return v2;
        })));
    }
}

