/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.conf.service.api.enums.live;

import cn.com.duiba.live.conf.service.api.util.NumberUtil;
import com.google.common.collect.Maps;
import java.util.Map;

public enum LiveGuessRedSendTypeEnum {
    FIX_AMOUNT(1, "\u56fa\u5b9a\u91d1\u989d"),
    PARTITION_AMOUNT(2, "\u74dc\u5206\u91d1\u989d");

    private final Integer sendType;
    private final String desc;
    private static final Map<Integer, LiveGuessRedSendTypeEnum> ENUM_MAP;

    public static boolean contains(Integer sendType) {
        if (NumberUtil.isNullOrLteZero(sendType)) {
            return false;
        }
        return ENUM_MAP.containsKey(sendType);
    }

    public static LiveGuessRedSendTypeEnum getEnumItem(Integer sendType) {
        if (NumberUtil.isNullOrLteZero(sendType)) {
            return null;
        }
        return ENUM_MAP.get(sendType);
    }

    public Integer getSendType() {
        return this.sendType;
    }

    public String getDesc() {
        return this.desc;
    }

    private LiveGuessRedSendTypeEnum(Integer sendType, String desc) {
        this.sendType = sendType;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Maps.newHashMap();
        for (LiveGuessRedSendTypeEnum item : LiveGuessRedSendTypeEnum.values()) {
            ENUM_MAP.put(item.getSendType(), item);
        }
    }
}

