/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.conf.service.api.enums.conf.live;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum LiveDepartmentEnum {
    PC(1, "\u4fdd\u9669\u4e1a\u52a1"),
    BANK(2, "\u94f6\u884c\u76f4\u64ad"),
    CREDIT(3, "\u4fe1\u7528\u5361\u4e1a\u52a1"),
    WX_WORK(4, "\u4f01\u5fae\u4e1a\u52a1");

    private final Integer department;
    private final String name;
    private static final Map<Integer, LiveDepartmentEnum> ENUM_MAP;

    public static LiveDepartmentEnum getByDepartment(Integer department) {
        if (department == null) {
            return null;
        }
        return ENUM_MAP.get(department);
    }

    private LiveDepartmentEnum(Integer department, String name) {
        this.department = department;
        this.name = name;
    }

    public Integer getDepartment() {
        return this.department;
    }

    public String getName() {
        return this.name;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(LiveDepartmentEnum.values()).collect(Collectors.toMap(LiveDepartmentEnum::getDepartment, Function.identity(), (v1, v2) -> v2)));
    }
}

