package cn.com.duiba.live.normal.service.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.live.LiveUserAppointmentPushDto;
import cn.com.duiba.live.normal.service.api.param.live.LiveUserAppointmentPushSearchParam;

import java.util.List;

/**
 * 用户预约推送服务
 *
 * @author xuzhigang
 * @date 2020/8/3 4:47 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveUserAppointmentPushApiService {
    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 用户预约推送集合
     */
    List<LiveUserAppointmentPushDto> selectList(LiveUserAppointmentPushSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveUserAppointmentPushSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 用户预约推送
     */
    LiveUserAppointmentPushDto selectById(Long id);

    /**
     * 新增
     * @param dto 用户预约推送
     * @return 执行结果
     */
    int insert(LiveUserAppointmentPushDto dto);

    /**
     * 新增或推送剩余次数+1
     *
     * @param dto 用户预约推送
     * @return 执行结果
     */
    int insertOrIncreaseTimes(LiveUserAppointmentPushDto dto);

    /**
     * 批量新增
     * @param dtoList 用户预约推送集合
     * @return 执行结果
     */
    int batchInsertGeneratedKeys(List<LiveUserAppointmentPushDto> dtoList);

    /**
     * 更新
     * @param dto 用户预约推送
     * @return 执行结果
     */
    int update(LiveUserAppointmentPushDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}
