package cn.com.duiba.live.normal.service.api.remoteservice.liveclue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.liveclue.LiveClueReplyAdviceDto;
import cn.com.duiba.live.normal.service.api.param.liveclue.LiveClueReplyAdviceSearchParam;

import java.util.List;

/**
 * 直播线索回复建议
 * @author 吴文哲
 * @date 2020-04-13 14:25
 **/
@AdvancedFeignClient
public interface RemoteLiveClueReplyAdviceApiService {


    /**
     * 根据条件查询列表 不分页
     * @param param
     * @return
     */
    List<LiveClueReplyAdviceDto> findByCondition(LiveClueReplyAdviceSearchParam param);

    /**
     * 批量插入
     * @param buildReplyAdviceList
     * @return
     */
    Integer batchInsert(List<LiveClueReplyAdviceDto> buildReplyAdviceList);

    /**
     * 更新回复建议
     * @param updateDtos
     * @return
     */
    Integer batchUpdateReplyAdvice(List<LiveClueReplyAdviceDto> updateDtos);

    /**
     * 根据模板id 删除建议
     * @param templateId
     */
    Integer deleteByTemplateId(Long templateId);


}
