/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.normal.service.api.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LotteryCodeUtil {
    private static final Logger log = LoggerFactory.getLogger(LotteryCodeUtil.class);
    private static final Character[] PLACEHOLDERS = new Character[]{Character.valueOf('M'), Character.valueOf('F'), Character.valueOf('T'), Character.valueOf('A'), Character.valueOf('S'), Character.valueOf('X'), Character.valueOf('D'), Character.valueOf('P'), Character.valueOf('C'), Character.valueOf('I'), Character.valueOf('Y'), Character.valueOf('V'), Character.valueOf('N'), Character.valueOf('L'), Character.valueOf('J'), Character.valueOf('Q'), Character.valueOf('E'), Character.valueOf('U'), Character.valueOf('Z'), Character.valueOf('K'), Character.valueOf('R'), Character.valueOf('B'), Character.valueOf('H'), Character.valueOf('O'), Character.valueOf('W'), Character.valueOf('G')};
    private static final List<Character> list = new ArrayList<Character>(Arrays.asList(PLACEHOLDERS));
    private static final int SPLIT_LINE = 3333;
    private static final int CHAR_INDEX = 25;
    private static final int MAX_VALUE = 52078125;

    private LotteryCodeUtil() {
    }

    public static String encodeNumberAs10String(long value) {
        int cValue = LotteryCodeUtil.getCValue(value);
        int numberValue = cValue % 3333;
        int characterValue = cValue / 3333;
        String randomString = LotteryCodeUtil.getRandomString(cValue);
        char thirdChar = PLACEHOLDERS[characterValue % 25].charValue();
        char secondChar = PLACEHOLDERS[(characterValue /= 25) % 25].charValue();
        char firstChar = PLACEHOLDERS[characterValue / 25].charValue();
        return "" + thirdChar + StringUtils.leftPad((String)String.valueOf(numberValue *= 3), (int)5, (char)'0') + secondChar + firstChar + randomString;
    }

    private static String getRandomString(int cValue) {
        int last1 = cValue % 100;
        if (last1 == 0) {
            return "007";
        }
        int randomNum = last1 * last1 + last1 * 111 + 7;
        return StringUtils.leftPad((String)String.valueOf(randomNum %= 1000), (int)3, (char)'0');
    }

    private static int getCValue(long value) {
        int cValue = value > 52078125L ? (int)(value % 52078125L) : (int)value;
        return cValue;
    }

    public static int decode10StringAsNumber(String source) {
        char c1 = source.charAt(0);
        char c2 = source.charAt(6);
        char c3 = source.charAt(7);
        int i = list.indexOf(Character.valueOf(c3)) * 25 * 25 + list.indexOf(Character.valueOf(c2)) * 25 + list.indexOf(Character.valueOf(c1));
        int i1 = i * 3333;
        String substring = source.substring(1, 6);
        int i3 = Integer.valueOf(substring) / 3;
        return i1 + i3;
    }

    private static void test2() {
        String source = LotteryCodeUtil.encodeNumberAs10String(83325L);
        System.out.println(source);
        System.out.println(LotteryCodeUtil.decode10StringAsNumber(source));
    }

    private static void test1() {
        int index;
        for (int i = index = 50000000; i < 10000000 + index; ++i) {
            String source = LotteryCodeUtil.encodeNumberAs10String(i);
            System.out.println(source);
            if (LotteryCodeUtil.decode10StringAsNumber(source) == i) continue;
            System.out.println("error = " + i);
            return;
        }
    }
}

