package cn.com.duiba.live.normal.service.api.remoteservice.agent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.agent.AgentAgreementRecordDto;

/**
 * 代理人同意协议记录
 * @author lizhi
 * @date 2020/10/9 6:29 PM
 */
@AdvancedFeignClient
public interface RemoteAgentAgreementRecordApiService {

    /**
     * 根据代理人和版本查询
     * @param agentId 代理人ID
     * @param agreementVersion 协议版本
     * @return 代理人同意协议记录
     */
    AgentAgreementRecordDto findByAgentAndVersion(Long agentId, Integer agreementVersion);

    /**
     * 保存代理人同意协议记录
     * @param dto 代理人同意协议记录
     * @return 执行结果
     */
    int insert(AgentAgreementRecordDto dto);
}
