package cn.com.duiba.live.normal.service.api.remoteservice.assist;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.assist.AssistDetailDto;
import cn.com.duiba.live.normal.service.api.dto.assist.AssistDto;
import cn.com.duiba.live.normal.service.api.param.assist.AssistAddParam;
import cn.com.duiba.live.normal.service.api.param.assist.AssistSearchParam;

import java.util.List;

/**
 * 机构帮扶管理
 * @author xiaotian
 * @date 2021/03/02 6:29 PM
 */
@AdvancedFeignClient
public interface RemoteAssistApiService {

    /**
     * 新增帮扶对象记录
     * @param assistAddParam
     * @return
     */
    Long addAssist(AssistAddParam assistAddParam);

    /**
     * 批量新增新增详情
     * @param assistDetailDtos
     * @return
     */
    Integer batchAddDetail(List<AssistDetailDto> assistDetailDtos);

    /**
     * 筛选列表
     * @return
     */
    List<AssistDto> queryList(AssistSearchParam assistSearchParam);

    /**
     * 筛选数量
     * @param assistSearchParam
     * @return
     */
    Long queryCount(AssistSearchParam assistSearchParam);

}
