package cn.com.duiba.live.normal.service.api.remoteservice.livepoint;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.livepoint.LivePointVideoInfoDto;
import cn.com.duiba.live.normal.service.api.dto.livepoint.LivePointVideoListDto;
import cn.com.duiba.live.normal.service.api.param.livepoint.LivePointRewardVideoAddParam;
import cn.com.duiba.live.normal.service.api.param.livepoint.LivePointRewardVideoEditParam;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-03-05 20:52
 */
@AdvancedFeignClient
public interface RemoteLivePointRewardService {
    /**
     * 点对点抽奖-新增备选视频
     *
     * @param livePointRewardVideoAddParam 备选视频
     * @return 视频id
     */
    Long addVideo(LivePointRewardVideoAddParam livePointRewardVideoAddParam);

    /**
     * 点对点抽奖-删除备选视频
     *
     * @param videoId 备选视频
     * @return 视频id
     */
    Boolean deleteVideo(Long videoId);

    /**
     * 点对点抽奖-编辑备选视频
     *
     * @param livePointRewardVideoEditParam
     * @return true成功 false失败
     */
    Boolean editVideo(LivePointRewardVideoEditParam livePointRewardVideoEditParam);

    /**
     * 获取备选视频详情
     *
     * @param videoId
     * @return
     */
    LivePointVideoInfoDto getVideoInfo(Long videoId);

    /**
     * 分页获取备选视频
     *
     * @param pageQuery 分页参数
     * @return 备选视频分页结果
     */
    List<LivePointVideoListDto> listVideo(int begin,int offset);

    /**
     * 统计备选视频总数
     *
     * @return 选视频总数
     */
    int countListVideo();

}
