package cn.com.duiba.live.normal.service.api.remoteservice.lottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.lottery.LiveLotteryCodeDto;
import cn.com.duiba.live.normal.service.api.dto.lottery.LiveLotteryUserCodeDto;
import cn.com.duiba.live.normal.service.api.param.lottery.LiveLotteryCodeSearchParam;

import java.util.List;
import java.util.Map;

/**
 * 直播抽奖码
 * @author lizhi
 * @date 2020/6/2 8:51 PM
 */
@AdvancedFeignClient
public interface RemoteLiveLotteryCodeApiService {

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 直播抽奖码集合
     */
    List<LiveLotteryCodeDto> selectList(LiveLotteryCodeSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(LiveLotteryCodeSearchParam param);

    /**
     * 根据主键批量查询
     * @param ids 主键集合
     * @return 抽奖码集合
     */
    List<LiveLotteryCodeDto> selectByIds(List<Long> ids);

    /**
     * 查询未使用的抽奖码
     * @param liveId 直播ID
     * @param liveVisitorIdList 直播用户ID集合
     * @return key：直播用户ID，value：抽奖码主键集合
     */
    Map<Long, List<Long>> findVisitorNotUsedIds(Long liveId, List<Long> liveVisitorIdList);

    /**
     * 查询未使用抽奖码数量
     * @param liveId 直播ID
     * @param liveVisitorIdList 直播用户ID集合
     * @return key：直播用户ID，value：数量
     */
    Map<Long, Long> findVisitorNotUsedCount(Long liveId, List<Long> liveVisitorIdList);

    /**
     * 批量插入抽奖码
     * @param list 抽奖码集合
     * @return 用户ID及抽奖码ID
     */
    List<LiveLotteryUserCodeDto> batchInsert(List<LiveLotteryCodeDto> list);

    /**
     * 根据直播ID 和 用户ID 查询列表
     * @return
     */
    List<LiveLotteryCodeDto> findByLiveIdAndUserIds(LiveLotteryCodeSearchParam param);

    /**
     * 批量更改为已使用
     * @param ids 主键
     * @return 执行结果
     */
    int batchUseCode(List<Long> ids);

    /**
     * 查询一个直播下某种类型的抽奖券，一批用户的领取数量
     * @param liveId
     * @param liveUserIds
     * @param codeSource
     * @return key: liveUserId； value：数量
     */
    Map<Long, Long> selectOneSourceLotteryCodeNumByLiveIdAndUserIds(Long liveId, List<Long> liveUserIds, Integer codeSource);

    /**
     * 删除抽奖码
     * @param liveId 直播间id
     * @param inviteeId 被邀请的人的用户id
     * @return 影响行数
     */
    int deleteByLiveIdAndInviteeId(Long liveId,Long liveUserId,Long inviteeId);

}
