package cn.com.duiba.live.normal.service.api.remoteservice.successcase;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.successcase.LiveSuccessCaseDto;
import cn.com.duiba.live.normal.service.api.param.livecase.LiveSuccessCaseSearchParam;

import java.util.List;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020-07-23 15:28
 */
@AdvancedFeignClient
public interface RemoteLiveSuccessCaseApiService {


    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播引用成功案例关系集合
     */
    List<LiveSuccessCaseDto> selectPage(LiveSuccessCaseSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveSuccessCaseSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播引用成功案例关系
     */
    LiveSuccessCaseDto selectById(Long id);

    /**
     * 新增
     * @param dto 直播引用成功案例关系
     * @return 执行结果
     */
    int insert(LiveSuccessCaseDto dto);

    /**
     * 更新
     * @param dto 直播引用成功案例关系
     * @return 执行结果
     */
    int update(LiveSuccessCaseDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}
