package cn.com.duiba.live.normal.service.api.param.pointreward;

import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 点对点中奖活动
 * @author kjj mybatis generator 
 * @date 2021-03-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class RewardActivitySearchParam extends PageQuery {
     
    private static final long serialVersionUID = 1615182835765159L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 代理人id
     */
    private Long agentId;

    /**
     * 代理人用户id
     */
    private Long userId;

    /**
     * 活动关联的资源类型 1=视频
     * @see cn.com.duiba.live.normal.service.api.enums.pointreward.PointRewardResourceTypeEnum
     */
    private Integer resourceType;

    /**
     * 活动关联的id
     */
    private Long resourceId;

    /**
     * 奖品名称
     */
    private String awardName;

    /**
     * 奖品图片
     */
    private String awardImage;

    /**
     * 奖品总库存
     */
    private Integer awardStock;

    /**
     * 奖品剩余数量
     */
    private Integer awardLeft;

    /**
     * 活动类型
     * @see cn.com.duiba.live.normal.service.api.enums.pointreward.PointRewardActivityTypeEnum
     */
    private Integer activityType;

    /**
     * 活动状态
     * @see cn.com.duiba.live.normal.service.api.enums.pointreward.PointRewardActivityStatusEnum
     */
    private Integer activityStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}