package cn.com.duiba.live.normal.service.api.param.pointreward;

import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-03-15 14:11
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class RewardActivityListSearchParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = 5396276773658082852L;

    /**
     * 活动类型 1=点对点抽奖 2=社群抽奖
     * @see cn.com.duiba.live.normal.service.api.enums.pointreward.PointRewardActivityTypeEnum
     */
    private Integer activityType;

    /**
     * 用户id
     */
    private Long liveUserId;

    /**
     * 活动的状态
     * @see cn.com.duiba.live.normal.service.api.enums.pointreward.PointRewardActivityStatusEnum
     */
    private Integer activityStatus;

}
