package cn.com.duiba.live.normal.service.api.remoteservice.pointreward;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.pointreward.RewardPushDto;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2021-03-15 11:42
 * @descript 活动推动订阅 remoteService
 */
@AdvancedFeignClient
public interface RemoteRewardPushApiService {

    /**
     * 批量新增
     * @param rewardPushes 活动推送
     * @return 插入结果
     */
    Integer batchInsert(List<RewardPushDto> rewardPushes);

    /**
     * 根据活动id、用户id、推送类型查询记录
     * @param activityId 活动id
     * @param liveUserId 用户id
     * @param pushType 推送类型
     * @return 结果
     */
    RewardPushDto selectByAidUidPid(Long activityId, Long liveUserId, Integer pushType);
}
