package cn.com.duiba.live.normal.service.api.util;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

/**
 * Created by dugq on 2020-06-03.
 */
@Slf4j
public class LotteryCodeUtil {
    //25进值对照表
    private static final Character[] PLACEHOLDERS = new Character[]{'M', 'F', 'T', 'A', 'S', 'X', 'D', 'P', 'C', 'I', 'Y', 'V', 'N', 'L', 'J', 'Q', 'E', 'U', 'Z', 'K', 'R', 'B', 'H', 'O', 'W', 'G'};

    private static final List<String> RANDOM_LIST;

    /**
     * 支持的最大可还原ID，超过此ID时，将会取模运算
     */
    private static final Long MAX_LIVE_ID = 25*25L;

    private static final Long MAX_LOTTERY_CODE_ID = 100000000L;


    static {
       String str = "99,30,74,75,35,17,67,43,01,62,03,66,84,79,26,39,97,52,25,87,55,60,05,44,90,70,63,06,13,11,28,83,72,82,32,37,64,14,10,57,40,00,45,81,96,42,09,19,04,23,18,12,16,47,02,91,80,36,76,29,48,24,56,33,92,78,50,41,07,31,34,21,89,86,08,73,22,69,51,98,27,88,68,94,71,38,85,49,15,93,54,77,61,53,95,46,20,58,59,65";
       String[]  split = StringUtils.split(str,",");
        RANDOM_LIST = Collections.unmodifiableList(Arrays.asList(split));
        str = null;
        split = null;
    }

    /**
     * 私有化
     */
    private LotteryCodeUtil(){ }

    public static String encodeId2String(Long liveId,Long lotteryCodeId){
        if (Objects.isNull(liveId)||Objects.isNull(lotteryCodeId)){
            return null;
        }
        final Pair<Character, Character> livePair = getTwoCharByLiveId(liveId);
        final Pair<String, String> codePair = getDoubleFourByteNumById(lotteryCodeId);
        return livePair.getLeft()+codePair.getLeft() +livePair.getRight() + codePair.getRight();
    }

    private static Pair<Character,Character> getTwoCharByLiveId(long liveId){
        if (liveId>MAX_LIVE_ID){
            liveId = liveId % MAX_LIVE_ID;
        }
        int first = (int)liveId % 25;
        int last = (int)liveId / 25;
        return ImmutablePair.of(PLACEHOLDERS[first], PLACEHOLDERS[last]);
    }

    private static Pair<String,String> getDoubleFourByteNumById(long lotteryCodeId){
        if (lotteryCodeId>MAX_LOTTERY_CODE_ID){
            lotteryCodeId = lotteryCodeId % MAX_LOTTERY_CODE_ID;
        }
        final long lowFourByte = lotteryCodeId % 10000;
        final long highFourByte = lotteryCodeId / 10000;
        final Pair<String, String> highPair = getDoubleTwoCharByte(highFourByte);
        final Pair<String, String> lowPair = getDoubleTwoCharByte(lowFourByte);
        return ImmutablePair.of(lowPair.getLeft()+highPair.getRight(),lowPair.getRight()+highPair.getLeft());
    }

    private static Pair<String,String> getDoubleTwoCharByte(long sourceNum){
        if (sourceNum>=10000){
            sourceNum = sourceNum % 10000;
        }
        final long lowTwoByte = sourceNum % 100;
        final long highTwoByte = sourceNum / 100;
        return ImmutablePair.of(RANDOM_LIST.get((int) highTwoByte), RANDOM_LIST.get((int) lowTwoByte));
    }

    public static void main(String[] args) {
        final long start = System.currentTimeMillis();
        HashMap<String,String> set = new HashMap<>();
        for (long i = 0 ; i < 1000000; i++){
            for (long j = 1 ; j < 10; j++){
                final String old = set.put(encodeId2String(j, i), i+"-"+j);
                if (Objects.nonNull(old)){
                    System.out.println(old + "==== "+i+"-"+j);
                }
            }
        }
        final long cost = System.currentTimeMillis() - start;
        System.out.println("cost ======= "+cost+"size="+set.size());
    }
}
