package cn.com.duiba.live.normal.service.api.remoteservice.pointreward;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.pointreward.RewardJoinerDto;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2021-03-08 17:26
 * @descript 点对点中奖用户 remoteService
 */
@AdvancedFeignClient
public interface RemoteRewardJoinerApiService {

    /**
     * 根据活动id 和 用户id 查询中奖记录
     * @param activityId 活动id
     * @param liveUserId 用户id
     * @return 中奖记录
     */
    RewardJoinerDto findByActivityIdAndUid(Long activityId, Long liveUserId);

    /**
     * 分页查询列表
     * @param pageIndex 页序
     * @param pageSize 每页大小
     * @param activityId 活动id
     * @param joinType 参与类型
     * @return 列表
     */
    List<RewardJoinerDto> findPageByActivityId(Integer pageIndex, Integer pageSize, Long activityId, Integer joinType);

    /**
     * 参与活动
     * @param activityId 活动id
     * @param liveUserId 用户id
     * @return 参与记录id
     */
    Long join(Long activityId, Long liveUserId);

    /**
     * 批量更新
     * @param dtos 更新的数据
     * @return 更新结果
     */
    void batchUpdate(List<RewardJoinerDto> dtos);
}
