package cn.com.duiba.live.normal.service.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.live.LiveRecycleSuccessCaseDto;

/**
 * 回收成功案例服务
 *
 * @author xuzhigang
 * @date 2020/8/11 10:02 上午
 **/
@AdvancedFeignClient
public interface RemoteLiveRecycleSuccessCaseApiService {
    /**
     * 新增/编辑
     *
     * @param dto 回收成功案例
     * @return true-成功 false-失败
     */
    boolean saveOrUpdate(LiveRecycleSuccessCaseDto dto);

    /**
     * 根据liveId查询
     *
     * @param liveId 直播Id
     * @return 回收成功案例
     */
    LiveRecycleSuccessCaseDto selectByLiveId(Long liveId);

    /**
     * 根据liveId查询已开启的
     *
     * @param liveId 直播Id
     * @return 回收成功案例
     */
     LiveRecycleSuccessCaseDto selectByLiveIdEnabled(Long liveId);

}
