package cn.com.duiba.live.normal.service.api.param.common;

import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 直播公共红包领取记录表
 * @author kjj mybatis generator 
 * @date 2021-01-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveCommonRedReceiveSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16118912839821983L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 业务类型，与paycenter的bizType一致
     */
    private Byte bizType;

    /**
     * 业务方订单号
     */
    private String bizTradeNo;

    /**
     * 红包金额
     */
    private Integer receiveAmount;

    /**
     * 领取状态：1-未领取，2-领取中，3-领取成功，4-领取失败
     */
    private Byte receiveStatus;

    /**
     * 领取时间
     */
    private Date receiveTime;

    /**
     * 申请商户号的appid或商户号绑定的appid
     */
    private String appId;

    /**
     * 用户的标识，对公众号唯一
     */
    private String openId;

    /**
     * 用户真实ip
     */
    private String clientIp;

    /**
     * 错误码信息
     */
    private String errCode;

    /**
     * 失败码
     */
    private Integer failCode;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}