package cn.com.duiba.live.normal.service.api.remoteservice.videospecaward;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.videoSpecAward.VideoSpecAwardConfDto;
import cn.com.duiba.live.normal.service.api.param.videoSpecAward.VideoSpecAwardConfQueryParam;

import java.util.List;

/**
 * 视频集锦指定中奖配置rpc接口
 * @author 吴文哲
 * @date 2021/1/25 7:08 下午
 **/
@AdvancedFeignClient
public interface RemoteVideoSpecAwardConfApiService {

    /**
     * 保存精彩集锦指定中奖配置信息
     * @param confDto 配置信息
     * @return 主键id
     */
    Long saveVideoSpecAwardConf(VideoSpecAwardConfDto confDto);

    /**
     * 根据直播代理人id 配置状态查询视频指定中奖配置列表
     * @param param 查询参数
     * @see cn.com.duiba.live.normal.service.api.enums.specaward.VideoSpecAwardConfStatusEnums
     * @return
     */
    List<VideoSpecAwardConfDto> selectByAgentIdAndStatus(VideoSpecAwardConfQueryParam param);

    /**
     * 根据主键查询配置
     * @param confId 主键id
     * @return 视频指定中奖配置
     */
    VideoSpecAwardConfDto selectById(Long confId);

    /**
     * 根据代理人id视频id统计活动配置数量
     * @param liveAgentId 直播代理人id
     * @param videoId 视频id
     * @return 精彩集锦配置数量
     */
    Integer countByAgentIdAndVideoId(Long liveAgentId, Long videoId);

    /**
     * 根据主键id查询
     * @param videoConfIds 视频配置主键id列表
     * @return 视频指定中奖配置列表
     */
    List<VideoSpecAwardConfDto> selectByIds(List<Long> videoConfIds);
}
