package cn.com.duiba.live.normal.service.api.dto.guide;

import lombok.Data;

import java.io.Serializable;

/**
 * 引导视频-用户观看记录
 * @author kjj mybatis generator 
 * @date 2020-11-17
 */
@Data
public class GuideVideoVisitorStatsDto implements Serializable {
     
    private static final long serialVersionUID = 16055835362948600L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播用户id
     */
    private Long liveVisitorId;

    /**
     * 视频类型：1-基础教程，2-高级教程
     * @see cn.com.duiba.kjy.livecenter.api.enums.guide.GuideVideoTypeEnum
     */
    private Integer videoType;

    /**
     * 引导视频id, tb_guide_video.id
     */
    private Long videoId;

    /**
     * 用户观看最大时间点，单位秒
     */
    private Integer watchPoint;

    /**
     * 观看状态，1-未观看，2-观看中，3-已看完
     * @see cn.com.duiba.kjy.livecenter.api.enums.guide.GuideWatchStatusEnum
     */
    private Integer watchStatus;
}