package cn.com.duiba.live.normal.service.api.dto.oto.cust;

import cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustValueEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * OTO客户信息表
 * @author kjj mybatis generator 
 * @date 2022-01-10
 */
@Data
public class OtoCustomerDto implements Serializable {
     
    private static final long serialVersionUID = 16417939475489692L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 表单记录id tb_pub_form_record.id
     */
    private Long formRecordId;

    /**
     * 手机号码
     */
    private String phoneNum;

    /**
     * 客户姓名
     */
    private String custName;

    /**
     * 客户所在省市区
     */
    private String custArea;

    /**
     * 客户出生年份
     */
    private String custBirthYear;

    /**
     * 客户备注
     */
    private String custDescription;

    /**
     * 客户价值 1XX代表未接通 2XX中XX代表分数 3XX代表系统高价值
     * @see OtoCustValueEnum
     */
    private Integer custValue;

    /**
     * 系统评定的客户价值 1XX代表未接通 2XX中XX代表分数 3XX代表系统高价值
     * @see OtoCustValueEnum
     */
    private Integer systemCustValue;

    /**
     * 是否星标客户
     */
    private Integer custStar;
}