package cn.com.duiba.live.normal.service.api.remoteservice.oto.log;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.log.CustCallLogDto;
import cn.com.duiba.live.normal.service.api.param.oto.log.OtoLogSearchParam;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-13 14:33
 */
@AdvancedFeignClient
public interface RemoteOtoCustCallLogService {

    /**
     * 根据客户id和销售id以及时间查询日志（时间逆序）
     * @param param 查询参数
     * @return 日志列表
     */
    List<CustCallLogDto> listByCustIdAndTime(OtoLogSearchParam param);

    /**
     * 根据日志id判断有没有下一条
     * @param param 查询参数
     * @return 是否有下一条
     */
    boolean hasNext(OtoLogSearchParam param);
}
