package cn.com.duiba.live.normal.service.api.enums.oto.cust.ext;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-06 14:39
 * 客户核心决策人枚举
 */
@Getter
@AllArgsConstructor
public enum OtoCustCoreMakerEnum {

    UN_KNOW(1, "不明或其他"),
    SELF_OR_MATE(1, "个人或配偶"),
    CHILDREN(3, "子女"),
    PARENT(4, "父母");


    private final Integer type;

    private final String desc;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustCoreMakerEnum::getType, OtoCustCoreMakerEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据类型获取描述
     */
    public static String getDescByType(Integer type){
        if (type == null) {
            return null;
        }
        return ALL_MAP.get(type);
    }
}
