package cn.com.duiba.live.normal.service.api.param.oto.cust;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-11 17:50
 */
@Data
public class OtoFollowCustSearchParam implements Serializable {

    private static final long serialVersionUID = -9193639844857977932L;

    /**
     * 销售id
     */
    private Long otoSid;

    /**
     * 客户分类枚举
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.follow.OtoCustClassifyEnum
     */
    private Integer custClassifyType;

    /**
     * 跟进状态
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.follow.OtoCustFollowStatusEnum
     */
    private Long followStatus;

    /**
     * 分配起始时间
     */
    private Date assignBeginTime;

    /**
     * 分配结束时间
     */
    private Date assignEndTime;

    /**
     * 跟进起始时间
     */
    private Date followBeginTime;

    /**
     * 跟进结束时间
     */
    private Date followEndTime;
}
