package cn.com.duiba.live.normal.service.api.remoteservice.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.red.LiveRedHelpVisitorIdDto;
import cn.com.duiba.live.normal.service.api.dto.red.LiveVisitorHelpDto;
import cn.com.duiba.live.normal.service.api.param.red.LiveVisitorHelpSearchParam;

import java.util.List;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/4/3 8:40 PM
 */
@AdvancedFeignClient
public interface RemoteLiveVisitorHelpApiService {

    /**
     * 分页查询
     * @param param 分页查询条件
     * @return 直播-助力关系集合
     */
    List<LiveVisitorHelpDto> selectPage(LiveVisitorHelpSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(LiveVisitorHelpSearchParam param);

    /**
     * 根据直播ID和访客ID查询助力信息
     * @param liveId 直播ID
     * @param visitorId 访客ID
     * @return 助力信息
     */
    LiveVisitorHelpDto selectByLiveAndVisitor(Long liveId, Long visitorId);

    /**
     * 根据主键集合查询助力信息
     * @param ids 主键集合
     * @return 助力信息
     */
    List<LiveVisitorHelpDto> selectByIds(List<Long> ids);

    /**
     * 保存助力
     * @param dto 直播-助力关系
     * @return 执行结果
     */
    int saveHelp(LiveVisitorHelpDto dto);

    /**
     * 保存助力
     * @param dto 直播-助力关系
     * @return 执行结果
     */
    Long save(LiveVisitorHelpDto dto);

    /**
     * 新增
     * @param dto 直播-助力关系
     * @return 执行结果
     */
    int insert(LiveVisitorHelpDto dto);

    /**
     * 助力人数+1
     * @param liveId 直播ID
     * @param id 红包ID
     * @param visitorId 访客ID
     */
    void increaseHelp(Long liveId, Long id, Long visitorId);

    /**
     * 批量获取访客助力人数
     * @param liveId 直播ID
     * @param id 红包ID
     * @param visitorIdList 访客ID集合
     * @return key：访客ID，value：助力人数
     */
    Map<Long, Long> batchGetHelpNum(Long liveId, Long id, List<Long> visitorIdList);

    /**
     * 批量查询助力人的ID集合
     * @param liveId 直播ID
     * @param confRedPacketId 红包ID
     * @param inviterIdList 邀请人ID
     * @return 助力人ID集合
     */
    List<LiveRedHelpVisitorIdDto> batchSelectVisitorIds(Long liveId, Long confRedPacketId, List<Long> inviterIdList);

    /**
     * 批量查询访客邀请人
     * @param liveId 直播ID
     * @param visitorIdList 访客ID集合
     * @return key：访客ID，value：邀请人ID
     */
    Map<Long, Long> batchSelectInviterId(Long liveId, List<Long> visitorIdList);

    /**
     * 获取访客助力人数
     * @param liveId 直播ID
     * @param id 红包ID
     * @param visitorId 访客ID
     * @return 助力人数
     */
    long getHelpNum(Long liveId, Long id, Long visitorId);
}
