/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.normal.service.api.enums.oto.cust.ext;

import cn.com.duiba.live.normal.service.api.util.NumberUtil;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public enum OtoCustValueEnum {
    X("X", 101, "\u62e8\u6253\u672a\u63a5\u901a\u6b21\u6570 >= 5"),
    N("N", 102, "\u62e8\u6253\u6b21\u65705\u6b21\u5185\u672a\u63a5\u901a"),
    ZERO("0", 200, "\u9500\u552e\u624b\u52a8\u8f93\u5165"),
    ONE("1", 201, "\u9500\u552e\u624b\u52a8\u8f93\u5165"),
    TWO("2", 202, "\u9500\u552e\u624b\u52a8\u8f93\u5165"),
    THREE("3", 203, "\u9500\u552e\u624b\u52a8\u8f93\u5165"),
    THREE_A("3-A", 301, "\u9012\u4ea4\u4e86\u8ba1\u5212\u4e66\uff0c\u8fd1\u671f\u6709\u673a\u4f1a\u6210\u4ea4"),
    THREE_B("3-B", 302, "\u9012\u4ea4\u4e86\u8ba1\u5212\u4e66\uff0c\u8fd1\u671f\u65e0\u6cd5\u6210\u4ea4"),
    THREE_C("3-C", 303, "");

    private final String showValue;
    private final Integer realValue;
    private final String desc;
    private static final Set<Integer> LOWER_VALUE_LIST;
    private static final Set<Integer> NUMBER_VALUE_LIST;
    private static final Set<Integer> PLAN_OR_DEL_LIST;
    private static final Map<Integer, String> ALL_MAP;

    public static String getShowValue(Integer realValue) {
        if (NumberUtil.isNullOrLteZero(realValue)) {
            return null;
        }
        return ALL_MAP.get(realValue);
    }

    public static boolean canReplace(Integer oldValue, Integer newValue) {
        if (newValue == null) {
            return false;
        }
        if (oldValue == null && NUMBER_VALUE_LIST.contains(newValue)) {
            return true;
        }
        if (newValue.equals(oldValue)) {
            return true;
        }
        if (LOWER_VALUE_LIST.contains(oldValue)) {
            return LOWER_VALUE_LIST.contains(newValue) || NUMBER_VALUE_LIST.contains(newValue);
        }
        if (NUMBER_VALUE_LIST.contains(oldValue)) {
            return NUMBER_VALUE_LIST.contains(newValue) && newValue > oldValue;
        }
        return false;
    }

    public String getShowValue() {
        return this.showValue;
    }

    public Integer getRealValue() {
        return this.realValue;
    }

    public String getDesc() {
        return this.desc;
    }

    private OtoCustValueEnum(String showValue, Integer realValue, String desc) {
        this.showValue = showValue;
        this.realValue = realValue;
        this.desc = desc;
    }

    static {
        LOWER_VALUE_LIST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Integer[]{X.getRealValue(), N.getRealValue(), ZERO.getRealValue()}));
        NUMBER_VALUE_LIST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Integer[]{ZERO.getRealValue(), ONE.getRealValue(), TWO.getRealValue(), THREE.getRealValue()}));
        PLAN_OR_DEL_LIST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Integer[]{THREE_A.getRealValue(), THREE_B.getRealValue(), THREE_C.getRealValue()}));
        ALL_MAP = Collections.unmodifiableMap(Arrays.stream(OtoCustValueEnum.values()).collect(Collectors.toMap(OtoCustValueEnum::getRealValue, OtoCustValueEnum::getShowValue)));
    }
}

