package cn.com.duiba.live.normal.service.api.param.oto.cust;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-12 13:40
 */
@Data
public class OtoCustomerEditParam implements Serializable {

    private static final long serialVersionUID = -380981159017959838L;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 客户姓名
     */
    private String custName;

    /**
     * 省市区
     */
    private String custArea;

    /**
     * 备注
     */
    private String custDescription;

    /**
     * 加微信状态
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustWxStatusEnum
     */
    private Integer addWxStatus;

    /**
     * 参观进度
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustVisitProgressEnum
     */
    private Integer visitProgress;

    /**
     * 是否成交
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer dealFlag;

    /**
     * 是否提交计划书
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer commitPlanFlag;

    /**
     * 核心决策人
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustCoreMakerEnum
     */
    private Integer coreMaker;

    /**
     * 年龄
     */
    private Integer age;

    /**
     * 为谁考虑
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustForWhoEnum
     */
    private List<Integer> forWho;

    /**
     * 入住人年龄
     */
    private Integer roomerAge;

    /**
     * 入住人所在城市
     */
    private String roomerCity;

    /**
     * 考虑原因
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustReasonEnum
     */
    private Integer considerReason;

    /**
     * 保费付费压力
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustPressureEnum
     */
    private Integer payPressure;

    /**
     * 退休金
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustRetireMoneyEnum
     */
    private Integer retireMoney;

    /**
     * 参观机构
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustVisitOrgEnum
     */
    private List<Integer> visitOrg;

    /**
     * 资金情况
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustMoneyEnum
     */
    private Integer hasMoney;

    /**
     * 房产情况
     */
    private Integer hasHouse;

    /**
     * 家人态度
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustFamilyAttitudeEnum
     */
    private Integer familyAttitude;
}
