package cn.com.duiba.live.normal.service.api.remoteservice.oto.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.cust.CustFollowDto;
import cn.com.duiba.live.normal.service.api.dto.oto.cust.OtoCustClassifyCountDto;
import cn.com.duiba.live.normal.service.api.dto.oto.cust.OtoCustFollowCountDto;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-08 14:55
 * 客户跟进机会service
 */
@AdvancedFeignClient
public interface RemoteOtoCustFollowService {

    /**
     * 新增
     * @param dto 客户跟进记录
     * @return 执行结果
     */
    boolean insert(CustFollowDto dto);

    /**
     * 更新
     * @param dto 客户跟进记录
     * @return 执行结果
     */
    boolean update(CustFollowDto dto);

    /**
     * 客户跟进信息
     * @param custId 客户id
     * @return 客户跟进信息
     */
    CustFollowDto findByCustId(Long custId);

    /**
     * 根据客户id批量查询客户跟进信息
     *
     * @param custIds 客户id
     * @return 客户跟进信息
     */
    List<CustFollowDto> listByCustIds(List<Long> custIds);

    /**
     * 根据客户分类统计客户数
     * @param otoSid oto销售id
     * @return 客户统计数
     */
    List<OtoCustClassifyCountDto> countByCustClassify(Long otoSid);

    /**
     * 根据客户跟进状态统计客户数
     * @param otoSid oto销售id
     * @return 客户统计数
     */
    List<OtoCustFollowCountDto> countByFollowStatus(Long otoSid);
}
