package cn.com.duiba.live.normal.service.api.remoteservice.risk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.risk.LiveUserRiskLevelDto;

import java.util.List;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020/12/3 16:31
 */
@AdvancedFeignClient
public interface RemoteLiveUserRiskLevelApiService {

    /**
     * 根据直播用户id查询
     * @param liveUserId 直播用户id
     * @return 用户风险等级信息
     */
    LiveUserRiskLevelDto findByLiveUserId(Long liveUserId);

    /**
     * 根据直播用户id查询
     * @param liveUserIds 直播用户id集合
     * @return 用户风险等级信息集合
     */
    List<LiveUserRiskLevelDto> findByLiveUserIds(List<Long> liveUserIds);

    /**
     * 批量新增或修改
     * @param list 用户风险等级信息集合
     * @return 执行结果
     */
    int batchInsertOrUpdate(List<LiveUserRiskLevelDto> list);

}
