package cn.com.duiba.live.normal.service.api.dto.oto.cust;

import cn.com.duiba.live.normal.service.api.enums.oto.cust.follow.OtoCustClassifyEnum;
import cn.com.duiba.live.normal.service.api.enums.oto.cust.follow.OtoCustFollowStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 客户跟进记录表
 * @author kjj mybatis generator 
 * @date 2022-01-08
 */
@Data
public class CustFollowDto implements Serializable {
     
    private static final long serialVersionUID = 16416295409212211L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 当前跟进销售id
     */
    private Long sellerId;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 当前跟进状态 1需要联系 2需要约见 3要发计划书 4待促成
     * @see OtoCustFollowStatusEnum
     */
    private Integer followStatus;

    /**
     * 客户分类 1需要联系客户 2星标客户 3需要约见客户 4需复拨客户
     * @see OtoCustClassifyEnum
     */
    private Integer custClassify;

    /**
     * 跟进次数
     */
    private Integer followTimes;

    /**
     * 跟进客户权重
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.follow.OtoCustFollowWeightEnum
     */
    private Integer followWeight;

    /**
     * 最近跟进时间 面访，参观，打电话都算跟进
     */
    private Date lastFollowTime;

    /**
     * 最近分配时间
     */
    private Date lastAssignTime;

    /**
     * 历史跟进人销售id（用,隔开）
     */
    private String historyFollower;

    /**
     * 评价类型
     * @see cn.com.duiba.live.normal.service.api.enums.oto.OtoCommentTypeEnum
     */
    private Integer commentType;

    /**
     * 分配类型
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.follow.OtoCustAssignTypeEnum
     */
    private Integer assignType;
}