package cn.com.duiba.live.normal.service.api.enums.oto.cust.ext;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-11 14:11
 */
@Getter
@AllArgsConstructor
public enum OtoCustRetireMoneyEnum {

    FIVE(0, "0-5000"),
    EIGHT(1, "5000-8000"),
    TWELVE(2, "8000-12000"),
    TWELVE_MORE(3, "12000+");


    /**
     * 是否由系统判定
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustRetireMoneyEnum::getType, OtoCustRetireMoneyEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据类型获取描述
     */
    public static String getDescByType(Integer type){
        if (type == null) {
            return null;
        }
        return ALL_MAP.get(type);
    }
}
