package cn.com.duiba.live.normal.service.api.enums.oto.cust.log;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-06 17:57
 * 操作客户场景枚举
 */
@Getter
@AllArgsConstructor
public enum OtoCustOperationSceneEnum {

    INFO(1, "资料编辑"),
    VALUE(2, "客户价值更新"),
    TAG(3, "客户标签更新"),
    VISIT(4, "预约参观状态更新"),
    CALL(5, "打电话"),
    MEET(6, "面访"),
    FOLLOW_WEIGHT(7, "跟进权重更新"),
    ;

    /**
     * 场景值
     */
    private final Integer scene;

    /**
     * 描述
     */
    private final String desc;
}
