package cn.com.duiba.live.normal.service.api.enums.pub.form;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.collections4.map.HashedMap;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 回传记录表标签枚举
 *
 * @author xiaocong
 * @date 2021/11/3 11:08 上午
 */

@Getter
@AllArgsConstructor
public enum RecordLabelEnum {


    /**
     * 其他
     */
    OTHER(-1, "其他"),

    /**
     * 暂无
     */
    NOT(0, "暂无"),

    /**
     * 有效
     */
    VALID(1, "有效"),

    /**
     * 无效
     */
    INVALID(2, "无效的");

    /**
     * 标签状态码
     */
    private final Integer code;

    /**
     * 标签描述
     */
    private final String description;

    public static final Map<Integer, RecordLabelEnum> LABEL_MAP;

    static {
        Map<Integer, RecordLabelEnum> map = Arrays.stream(values()).collect(Collectors.toMap(RecordLabelEnum::getCode, Function.identity()));
        LABEL_MAP = Collections.unmodifiableMap(map);
    }

    /**
     * 通过code获得枚举
     * @param code
     * @return
     */
    public static RecordLabelEnum getByCode(Integer code) {
        if (Objects.isNull(code)) {
            return INVALID;
        }
        return LABEL_MAP.get(code);
    }
}
