package cn.com.duiba.live.normal.service.api.param.black;

import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * 直播黑名单源头用户表
 * @author kjj mybatis generator 
 * @date 2020-09-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class LiveBlackSourceSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16011888162488044L;

    /**
     * 直播用户id列表
     */
    private List<Long> liveUserIds;

    /**
     * 黑名单用户来源类型 1:访客 2:代理人
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.blackList.SourceTypeEnum
     */
    private Integer sourceType;

}