package cn.com.duiba.live.normal.service.api.remoteservice.advice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.advice.LiveAdviceRecordDto;
import cn.com.duiba.live.normal.service.api.dto.advice.LiveAdviceUnReadDto;
import cn.com.duiba.live.normal.service.api.param.advice.LiveAdvicePageParam;
import cn.com.duiba.live.normal.service.api.param.advice.LiveAdviceRecordSearchParam;

import java.util.List;
import java.util.Map;

/**
 * @author liuchao1
 * @date 2020/6/30 15:40
 */
@AdvancedFeignClient
public interface RemoteLiveAdviceRecordApiService {

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播咨询记录集合
     */
    List<LiveAdviceRecordDto> selectPage(LiveAdviceRecordSearchParam param);

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 直播咨询记录集合
     */
    List<LiveAdviceRecordDto> selectList(LiveAdviceRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    int selectCount(LiveAdviceRecordSearchParam param);

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播咨询记录集合
     */
    List<LiveAdviceRecordDto> selectAdviceList(LiveAdvicePageParam param);

    /**
     * 批量查询聊天室记录数
     * @param sessionKeyList 聊天室sessionKey
     * @return key:sessionKey value：消息条数
     */
    Map<String, Integer> getSessionKeyMsgCount(List<String> sessionKeyList);

    /**
     * 获取访客的咨询条数
     * @param sessionKeyList 聊天室sessionKey
     * @return key:sessionKey value：访客咨询条数
     */
    Map<String, Integer> getVisitAdviceNumMap(List<String> sessionKeyList);

    /**
     * 查询代理人未读消息数
     * @param sessionKeyList 聊天室sessionKey
     * @return key：sessionKey value：未读消息数
     */
    Map<String, Integer> getVisitorNotReadNumMap(List<String> sessionKeyList);

    /**
     * 查询每个session、每个类型、未读ID集合
     * @param sessionKeyList 聊天室sessionKey
     * @param maxId 最大ID
     * @return 未读消息
     */
    List<LiveAdviceUnReadDto> selectUnReadIds(List<String> sessionKeyList, Long maxId);

    /**
     * 批量插入咨询记录
     * @param list 咨询记录集合
     * @return 回填主键后的对象
     */
    List<LiveAdviceRecordDto> batchInsert(List<LiveAdviceRecordDto> list);

    /**
     * 批量更新为已读
     * @param ids 主键集合
     * @return 执行结果
     */
    int batchUpdateRead(List<Long> ids);

}
