package cn.com.duiba.live.normal.service.api.remoteservice.related;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.related.LiveAgentUserRelatedDto;

import java.util.List;

/**
 * 直播代理人访客关联
 * @author 吴文哲
 * @date 2021/6/2 4:24 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveAgentUserRelatedApiService {

    /**
     * 根据直播间id + 工号 查询代理人访客关联数据
     * @param liveId 直播间id
     * @param jobNumber 工号
     * @return 主键列表
     */
    List<Long> findByLiveIdAndJobNumber(Long liveId, String jobNumber);

    /**
     * 根据直播间id + 访客手机号 查询代理人访客关联数据
     * @param liveId 直播间id
     * @param phoneNum 访客手机号
     * @return 代理人/访客关联数据
     */
    LiveAgentUserRelatedDto findByLiveIdAndPhoneNumber(Long liveId, String phoneNum);

    /**
     * 分页查询
     * @param liveId 直播间id
     * @param jobNumberList 工号列表
     * @return 代理人访客关联列表
     */
    List<LiveAgentUserRelatedDto> selectByLiveIdAndJobNumbers(Long liveId, List<String> jobNumberList);

    /**
     * 批量插入
     * @param addList 插入列表
     * @return 影响行数
     */
    int batchInsert(List<LiveAgentUserRelatedDto> addList);

    /**
     * 批量更新
     * @param updateList 更新列表
     * @return 影响行数
     */
    int batchUpdate(List<LiveAgentUserRelatedDto> updateList);

    /**
     * 根据主键更新代理人id
     * @param agentId 代理人id
     * @param ids 主键id列表
     * @return 影响行数
     */
    int updateAgentIdByIds(Long agentId,List<Long> ids);

    /**
     * 根据直播间id+ 手机号 更新访客用户id
     * @param liveUserId 访客直播用户id
     * @param id 主键
     * @return 影响行数
     */
    int updateLiveUserIdById(Long liveUserId,Long id);




}
