package cn.com.duiba.live.normal.service.api.dto.oto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * OTO-销售信息
 *
 * @author ZhangJun
 * @date 2022/1/7 5:16 下午
 */
@Data
public class OtoSellerDto implements Serializable {

    private static final long serialVersionUID = -6283587838740023380L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 销售手机号
     */
    private String phoneNumber;

    /**
     * 销售姓名
     */
    private String sellerName;

    /**
     * 销售账号状态,0-禁用,1-启用
     * {@link cn.com.duiba.live.normal.service.api.enums.oto.OtoSellerStatusEnum}
     */
    private Integer sellerStatus;

    /**
     * 呼叫权限,0-禁用,1-启用
     * {@link cn.com.duiba.live.normal.service.api.enums.oto.OtoSellerCallPermissionEnum}
     */
    private Integer callPermission;

    /**
     * 角色类型,1-普通销售,2-销售管理员
     * {@link cn.com.duiba.live.normal.service.api.enums.oto.OtoSellerRoleTypeEnum}
     */
    private Integer roleType;

    /**
     * 所属上级销售id
     */
    private Long parentId;

    /**
     * 销售等级,1=A,2=B,3=C
     * @see cn.com.duiba.live.normal.service.api.enums.oto.OtoSellerLevelEnum
     */
    private Integer sellerLevel;

    /**
     * 所属公司id
     * tb_oto_company.id
     */
    private Long sellerCompany;

    /**
     * 工作状态,0-非工作中,1=工作中
     * @see cn.com.duiba.live.normal.service.api.enums.oto.OtoSellerWorkStatusEnum
     */
    private Integer workStatus;

    /**
     * 离职状态，0-未离职，1-已离职
     * @see cn.com.duiba.live.normal.service.api.enums.oto.OtoSellerDimissionStatusEnum
     */
    private Integer dimissionStatus;

    /**
     * 销售所在地区
     */
    private String sellerArea;

    /**
     * 最后登录时间
     */
    private Date lastLoginTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}
