package cn.com.duiba.live.normal.service.api.param.oto.interview;

import cn.com.duiba.live.normal.service.api.enums.oto.interview.EvaluateDetailEnum;
import cn.com.duiba.live.normal.service.api.enums.oto.interview.ScanCodeTypeEnum;
import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 面访授权评价详情
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class InterviewAuthorizeEvaluateParam implements Serializable {

    private static final long serialVersionUID = 2643952600552454873L;

    /**
     * 扫码用户id
     */
    private Long scanUserId;

    /**
     * 扫码用户手机号
     */
    private String scanUserPhone;

    /**
     * 面访码ID
     */
    private Long interviewId;

    /**
     * 小程序码id
     */
    private Long scanCodeId;
    /**
     * 扫码方式
     * @see ScanCodeTypeEnum
     */
    private Integer scanCodeType;
    /**
     * 评价详情
     * @see EvaluateDetailEnum
     */
    private List<Integer> evaluateDetail;
}
